# Introduction ----- 

# Code for making figure 3 of the paper, which will relate to analysis of the spindle and SW data
#Including two example spectrograms

#Load up ----

pacman::p_load(tidyverse,patchwork,ghibli,eegUtils)


#Get our default settings
source("./eLife Submission Scripts/Analysis-Common-Utilities.R")


# Figure 3 ======

## Fig 3A-B: Example spectrograms =====

#Load the example dataset
example_data = 
  read_rds("./eLife Submission Data/sleep_study_eeg_spectrogram_example.rds")


p_spectro_22q = 
  example_data$spectrogram_22q |>
  filter(freq %in% seq(from = 0.25, to = 20, by = 0.25)) |>
  ggplot(aes(x = time, y = freq, fill = power)) +
  # geom_tile() +
  geom_raster() +
  scale_fill_viridis_c(limits = c(-15,15),
                       oob = scales::squish) +
  labs(x = "Time (24 Hour Clock)",y = "Frequency (Hz)",title = "Example Spectrogram 22q") +
  theme_bw() +
  theme(strip.background = element_blank(),
        panel.grid = element_blank(),
        strip.text = element_text(colour = "grey20",size = text_size),
        axis.text.y = element_text(colour = "grey20",size = text_size),
        axis.text.x = element_text(colour = "grey20",size = text_size),
        axis.title = element_text(colour = "black",size = text_size),
        legend.title = element_blank(),
        legend.justification = "top",
        legend.position = "none" ) +
  scale_x_datetime(expand = c(0,0),date_breaks = "1 hour",date_labels = "%X")  +
  scale_y_continuous(expand = c(0,0)) 


p_hypno_22q = 
  example_data$hypnogram_22q |>
  ggplot(aes(x = time, y = -hypno)) + 
  geom_step() + 
  labs(title = "Example Hypnogram 22q",x = "Time (24 Hour Clock)",y = "Sleep Stage") +
  theme_bw() +
  theme(strip.background = element_blank(),
        panel.grid = element_blank(),
        strip.text = element_text(colour = "grey20",size = text_size),
        axis.text.y = element_text(colour = "grey20",size = text_size),
        axis.text.x = element_text(colour = "grey20",size = text_size),
        axis.title = element_text(colour = "black",size = text_size),
        legend.title = element_blank(),
        legend.justification = "top",
        legend.position = "none" ) +
  scale_x_datetime(expand = c(0,0),date_breaks = "1 hour",date_labels = "%X")  +
  scale_y_continuous(expand = c(0,0),
                     breaks = c(-4,-3,-2,-1,0,1),
                     labels = c("-4" = "REM",
                                "-3" = "N3",
                                "-2" = "N2",
                                "-1" = "N1",
                                "0"  = "Wake",
                                "1"  = "Artefact")) 

p_event_22q = 
  example_data$event_dens_22q |>
  pivot_longer(-time,names_to = "event",values_to = "density") |>
  ggplot(aes(x = time,y = density)) +
  geom_line(size = 1) +
  facet_wrap(~event,ncol = 1) + 
  coord_cartesian(ylim = c(0,20)) +
  labs(title = "Example Event Density 22q",x = "Time (24 Hour Clock)",y = "Event/Min") +
  theme_bw() +
  theme(strip.background = element_blank(),
        panel.grid = element_blank(),
        strip.text = element_text(colour = "grey20",size = text_size),
        axis.text.y = element_text(colour = "grey20",size = text_size),
        axis.text.x = element_text(colour = "grey20",size = text_size),
        axis.title = element_text(colour = "black",size = text_size),
        legend.title = element_blank(),
        legend.justification = "top",
        legend.position = "none" ) +
  scale_x_datetime(expand = c(0,0),date_breaks = "1 hour",date_labels = "%X")  +
  scale_y_continuous(expand = c(0,0),breaks = c(0,5,10,15,20),position = "right")


#Now the sibling
p_spectro_sib = 
  example_data$spectrogram_Sib |>
  filter(freq %in% seq(from = 0.25, to = 20, by = 0.25)) |>
  ggplot(aes(x = time, y = freq, fill = power)) +
  # geom_tile() +
  geom_raster() +
  scale_fill_viridis_c(limits = c(-15,15),
                       oob = scales::squish) +
  labs(x = "Time (24 Hour Clock)",y = "Frequency (Hz)",title = "Example Spectrogram Sibling") +
  theme_bw() +
  theme(strip.background = element_blank(),
        panel.grid = element_blank(),
        strip.text = element_text(colour = "grey20",size = text_size),
        axis.text.y = element_text(colour = "grey20",size = text_size),
        axis.text.x = element_text(colour = "grey20",size = text_size),
        axis.title = element_text(colour = "black",size = text_size),
        legend.title = element_blank(),
        legend.justification = "top",
        legend.position = "none" ) +
  scale_x_datetime(expand = c(0,0),date_breaks = "1 hour",date_labels = "%X")  +
  scale_y_continuous(expand = c(0,0)) 


p_hypno_sib = 
  example_data$hypnogram_Sib |>
  ggplot(aes(x = time, y = -hypno)) + 
  geom_step() + 
  labs(title = "Example Hypnogram Sibling",x = "Time (24 Hour Clock)",y = "Sleep Stage") +
  theme_bw() +
  theme(strip.background = element_blank(),
        panel.grid = element_blank(),
        strip.text = element_text(colour = "grey20",size = text_size),
        axis.text.y = element_text(colour = "grey20",size = text_size),
        axis.text.x = element_text(colour = "grey20",size = text_size),
        axis.title = element_text(colour = "black",size = text_size),
        legend.title = element_blank(),
        legend.justification = "top",
        legend.position = "none" ) +
  scale_x_datetime(expand = c(0,0),date_breaks = "1 hour",date_labels = "%X")  +
  scale_y_continuous(expand = c(0,0),
                     breaks = c(-4,-3,-2,-1,0,1),
                     labels = c("-4" = "REM",
                                "-3" = "N3",
                                "-2" = "N2",
                                "-1" = "N1",
                                "0"  = "Wake",
                                "1"  = "Artefact")) 

p_event_sib = 
  example_data$event_dens_Sib |>
  pivot_longer(-time,names_to = "event",values_to = "density") |>
  ggplot(aes(x = time,y = density)) +
  geom_line(size = 1) +
  facet_wrap(~event,ncol = 1) + 
  labs(title = "Example Event Density Sibling",x = "Time (24 Hour Clock)",y = "Event/Min") +
  coord_cartesian(ylim = c(0,20)) +
  theme_bw() +
  theme(strip.background = element_blank(),
        panel.grid = element_blank(),
        strip.text = element_text(colour = "grey20",size = text_size),
        axis.text.y = element_text(colour = "grey20",size = text_size),
        axis.text.x = element_text(colour = "grey20",size = text_size),
        axis.title = element_text(colour = "black",size = text_size),
        legend.title = element_blank(),
        legend.justification = "top",
        legend.position = "none" ) +
  scale_x_datetime(expand = c(0,0),date_breaks = "1 hour",date_labels = "%X")  +
  scale_y_continuous(expand = c(0,0),breaks = c(0,5,10,15,20),position = "right")


#Assemble
p_example_22q = (p_spectro_22q / p_hypno_22q / p_event_22q + plot_layout(heights = c(3,0.75,1.5)))
p_example_sib = (p_spectro_sib / p_hypno_sib / p_event_sib + plot_layout(heights = c(3,0.75,1.5)))

p_example = p_example_sib | p_example_22q

#We do the final overlaying of elements in Inkscape

## Fig 3C: Spindle waveform data =====


#Preparing these bootstrapped confidence intervals takes a long time so we load previous done

# d_spin_i =
#   read_rds("./elife Submission Data/sleep_study_example_spindle_waveforms.rds")
# 
# d_spin =
#   d_spin_i |>
#   filter(location == "Cz" & xAx > -1 & xAx < 1) |>
#   group_by(location,xAx,group) |>
#   rename(power = data) |>
#   nest()  |>
#   mutate(mu      = map_dbl(data,mu_function2),
#          boot_t  = map(data,~boot(data = .x, statistic = mu_function2, R = 1000))) |>
#   mutate(boot_ci = map(boot_t,boot.ci, conf = 0.95, type = "bca" )) |>
#   mutate(ci      = map(boot_ci, ~.x$bca %>% as_tibble() |> select(V4,V5) |> rename(ci.low = V4, ci.high = V5)))

#This takes a long time to compute, so lets save it
# write_rds(d_spin,"./eLife Submission Data/sleep_study_example_spindle_waveforms_bootci.rds")

d_spin = read_rds("./eLife Submission Data/sleep_study_example_spindle_waveforms_bootci.rds")

p_spin_g = 
  d_spin %>%
  filter(location == "Cz" & xAx > -1 & xAx < 1) |>
  unnest(ci) |>
  mutate(group = factor(group, levels = c("Sib","22q"))) |>
  ggplot(aes(x = xAx, y = mu,ymin = ci.low,ymax = ci.high, colour = group, fill = group)) +
  facet_wrap(~group, ncol = 2) +
  geom_ribbon(alpha = 0.6,color = NA) +
  geom_line(size = 0.5) +
  theme_bw() +
  theme(strip.background = element_blank(),
        panel.grid  = element_blank(),
        strip.text  = element_text(colour = "grey20", size = text_size),
        axis.text.y = element_text(colour = "grey20", size = text_size),
        axis.text.x = element_text(colour = "grey20", size = text_size),
        axis.title  = element_text(colour = "black" , size = text_size),
        legend.title = element_blank(),
        legend.justification = "top",
        legend.position = "none" ) +
  labs(x = "Time (Seconds)", y = "microVolts") +
  scale_fill_manual(values = cols) +
  scale_colour_manual(values = cols) +
  scale_x_continuous(breaks = c(-0.5, 0,0.5),expand = c(0,0)) +
  coord_cartesian(ylim = c(-19,19))

## Fig 3D: SO waveform plots =============

# d_so_i =
#   read_rds("./eLife Submission Data/sleep_study_example_so_waveforms.rds")
# 
# d_so =
#   d_so_i |>
#   filter(location == "Cz" & xAx > -1 & xAx < 1) |>
#   group_by(location,xAx,group) |>
#   rename(power = data) |>
#   nest()  |>
#   mutate(mu      = map_dbl(data,mu_function2),
#          boot_t  = map(data,~boot(data = .x, statistic = mu_function2, R = 1000))) |>
#   mutate(boot_ci = map(boot_t,boot.ci, conf = 0.95, type = "bca" )) |>
#   mutate(ci      = map(boot_ci, ~.x$bca %>% as_tibble() |> select(V4,V5) |> rename(ci.low = V4, ci.high = V5)))
# 
# #This takes a long time to compute, so lets save it
# write_rds(d_so,"./eLife Submission Data/sleep_study_example_so_waveforms_bootci.rds")

d_so = read_rds("./eLife Submission Data/sleep_study_example_so_waveforms_bootci.rds")

p_so_g = 
  d_so %>%
  filter(location == "Cz" & xAx > -1 & xAx < 1) |>
  unnest(ci) |>
  mutate(group = factor(group, levels = c("Sib","22q"))) |>
  ggplot(aes(x = xAx, y = mu,ymin = ci.low,ymax = ci.high, colour = group, fill = group)) +
  facet_wrap(~group, ncol = 2) +
  geom_ribbon(alpha = 0.6,color = NA) +
  geom_line(size = 0.5) +
  theme_bw() +
  theme(strip.background = element_blank(),
        panel.grid  = element_blank(),
        strip.text  = element_text(colour = "grey20", size = text_size),
        axis.text.y = element_text(colour = "grey20", size = text_size),
        axis.text.x = element_text(colour = "grey20", size = text_size),
        axis.title  = element_text(colour = "black" , size = text_size),
        legend.title = element_blank(),
        legend.justification = "top",
        legend.position = "none" ) +
  labs(x = "Time (Seconds)", y = "microVolts") +
  scale_fill_manual(values = cols) +
  scale_colour_manual(values = cols) +
  scale_x_continuous(breaks = c(-0.5, 0,0.5),expand = c(0,0)) +
  coord_cartesian(ylim = c(-70,10))


## Fig 3E: Spindle Topoplots -----

#We will now plot the GAMM derived difference topoplots
d_gamm = read_rds("./eLife Submission Data/sleep_study_topoplot_posterior_data.rds")

#Prepare plotting labels
spindle_details <- 
  c(spin_freq    = "Spindle Frequency",
    spin_amp     = "Spindle Amplitude",
    spin_density = "Spindle Density")


#Difference plot
topo_spin_diff =
  d_gamm |>
  ungroup() |>
  select(measure,post_draws) |>
  filter(measure %in% c("spin_freq","spin_amp","spin_density" )) |>
  mutate(measure = factor(measure,levels = c("spin_density","spin_amp","spin_freq"))) |>
  unnest(post_draws) |>
  mutate(incircle = sqrt(x ^ 2 + y ^ 2) < circ_scale) %>%
  filter(incircle) %>%
  ggplot(aes(x = x, y = y, fill = diff)) +
  geom_raster(aes(alpha = pv)) +
  geom_mask(r = circ_scale, size = 0.5) +
  geom_head(r = circ_scale,size = 0.5) +                   
  scale_fill_distiller(palette = "RdBu", 
                       limits = c(-1,1),
                       oob = scales::squish) +
  coord_equal()+
  theme_void() +
  scale_alpha(range = c(0.1, 1)) +
  facet_wrap(~measure,ncol = 3,
             labeller = labeller(measure = spindle_details),
             strip.position = "top") +
  theme(legend.position = "bottom",
        strip.text = element_text(colour = "grey20",size = 8,angle = 0)) +
  guides(alpha = "none")


## Fig 3F: Slow wave Topoplots ======

so_details <- 
  c(so_density = "SW Density",
    so_amp     = "SW Amplitude",
    so_dur     = "SW Duration"
  )

#Difference plot
topo_so_diff =
  d_gamm |>
  ungroup() |>
  select(measure,post_draws) |>
  filter(measure %in% c("so_density","so_amp","so_dur" )) |>
  mutate(measure = factor(measure,levels = c("so_density","so_amp","so_dur"))) |>
  unnest(post_draws) |>
  mutate(incircle = sqrt(x ^ 2 + y ^ 2) < circ_scale) %>%
  filter(incircle) %>%
  ggplot(aes(x = x, y = y, fill = diff)) +
  geom_raster(aes(alpha = pv)) +
  geom_mask(r = circ_scale, size = 0.5) +
  geom_head(r = circ_scale,size = 0.5) +                   
  scale_fill_distiller(palette = "RdBu", 
                       limits = c(-1,1),
                       oob = scales::squish) +
  coord_equal()+
  theme_void() +
  scale_alpha(range = c(0.1, 1)) +
  facet_wrap(~measure,ncol = 3,
             labeller = labeller(measure = so_details),
             strip.position = "top") +
  theme(legend.position = "bottom",
        strip.text = element_text(colour = "grey20",size = 8,angle = 0)) +
  guides(alpha = "none")



## Assemble and save ====

#Example data
ggsave("./Figures/figure_3_example_spectrograms.pdf",plot = p_example, width = 24, height = 14, units = "cm")


#Waveforms
p_waveform = plot_spacer() + p_spin_g + plot_spacer() + p_so_g + plot_layout(widths = c(1,2,1,2))

# Topo difference plots
p_event     = topo_spin_diff|topo_so_diff
p_wave_topo = (p_waveform / p_event) + plot_layout(heights = c(1,2))


#Finally save
ggsave("./Figures/figure_3_event_topos.pdf",plot = p_wave_topo, width = 24, height = 12, units = "cm")



# Figure 3 Supplement 1: Individual Data =====


#Make individual data box plots and scatter plots with age
d_spin_so = 
  readr::read_rds("./eLife Submission Data/sleep_study_eeg_summary_data.rds")

d_spin_so_sum = 
  d_spin_so |>
  filter(measure %in% c("spin_density","spin_amp","spin_freq",
                        "so_density","so_amp","so_dur")) |>
  mutate(measure = factor(measure,levels = c("spin_density","spin_amp","spin_freq",
                                             "so_density","so_amp","so_dur"))) |>
  arrange(measure)

d_spin_so_sum$plot_labels = c("Spindle Density (Spindle/min)",
                              "Spindle Ampltiude (microV)",
                              "Spindle Frequency (Hz)",
                              "SW Density (SW/min)",
                              "SW Amplitude (microV)",
                              "SW Duration (seconds)")

## Fig 3 - S1A-F ------

p_individual_1 = 
  d_spin_so_sum |>
  ungroup() |>
  unnest(data) |>
  mutate(group = factor(group,levels = c("Sib","22q"))) |>
  filter(electrode == "Cz") |>
  group_by(measure, plot_labels) |>
  nest() |>
  mutate(plot = map2(data,plot_labels,
                      ~ggplot(data = .x, aes(x = group,y = value, fill = group,colour = group)) +
                       geom_boxplot(alpha = 0.2,
                                    lwd = 0.25,
                                    outlier.color = NA,
                                    outlier.fill = NA) +
                       geom_point(size = 0.5,
                                  position = ggforce::position_jitternormal(sd_x = 0.05, sd_y = 0),alpha = 0.6) +
                       scale_fill_manual(values = cols) +
                       scale_colour_manual(values = cols) +
                       theme_bw() +
                       theme(strip.background = element_blank(),
                             strip.text.x = element_blank(),
                             panel.grid = element_blank(),
                             strip.text = element_text(colour = "grey20",size = 8),
                             axis.text.y = element_text(colour = "grey20",size = 8),
                             axis.text.x = element_text(colour = "grey20",size = 8),
                             axis.title = element_text(colour = "black",size = 8),
                             legend.title = element_blank(),
                             legend.justification = "top",
                             legend.position = "none" ) +
                       labs(x = "Group", y = .y))) |>
  pull(plot) |>
  wrap_plots(ncol = 6)


## Fig 3 - S1G-L ------

p_individual_2 = 
  d_spin_so_sum |>
  ungroup() |>
  unnest(data) |>
  mutate(group = factor(group,levels = c("Sib","22q"))) |>
  filter(electrode == "Cz") |>
  group_by(measure, plot_labels) |>
  nest() |>
  mutate(plot = map2(data,plot_labels,
                      ~ggplot(data = .x, aes(x = age_eeg,y = value, fill = group,colour = group)) +
                       geom_point(size = 0.5,alpha = 0.6) +
                       geom_smooth(size = 0.5,
                                   formula = y ~ x,method = "lm") +
                       scale_fill_manual(values = cols) +
                       scale_colour_manual(values = cols) +
                       theme_bw() +
                       theme(strip.background = element_blank(),
                             strip.text.x = element_blank(),
                             panel.grid = element_blank(),
                             strip.text = element_text(colour = "grey20",size = 8),
                             axis.text.y = element_text(colour = "grey20",size = 8),
                             axis.text.x = element_text(colour = "grey20",size = 8),
                             axis.title = element_text(colour = "black",size = 8),
                             legend.title = element_blank(),
                             legend.justification = "top",
                             legend.position = "none" ) +
                       labs(x = "Age", y = .y))) |>
  pull(plot) |>
  wrap_plots(ncol = 6)

#Assemble

p_individual = p_individual_1 / p_individual_2  + plot_annotation(tag_levels = "A")

## Save =====

ggsave("./Figures/figure_3_supplement_1.pdf",plot = p_individual, width = 18, height = 8, units = "cm")


# Figure 3 Supplement 2: Group Topoplots =====

#Load the data
d_topo = 
  read_rds("./eLife Submission Data/sleep_study_eeg_summary_data.rds")

#Select only the measures of interest and prepare plotting labels
d_topo = 
  d_topo |>
  filter(str_detect(measure,"spin_") | str_detect(measure,"so_")) |>
  ungroup() |>
  mutate(measure     = factor(measure,levels = c("spin_density",
                                                 "spin_amp",
                                                 "spin_freq",
                                                 "so_density",
                                                 "so_amp",
                                                 "so_dur"))) |>
  arrange(measure) |>
  
  #Set up plot labels
  mutate(plot_labels = c("Spindle Density (Spindle/min)",
                         "Spindle Ampltiude (microV)",
                         "Spindle Frequency (Hz)",
                         "SW Density (SW/min)",
                         "SW Amplitude (microV)",
                         "SW Duration (seconds)"))

#Invert the SW amplitude data for plotting
d_topo$data[[5]]$value = -d_topo$data[[5]]$value

#Make the topoplots
topo_event_plots = 
  d_topo %>% 
  mutate(plots = map2(data,plot_labels, ~.x %>% ggplot(aes(x = x,
                                                           y = y,
                                                           z = value,
                                                           fill = value,
                                                           label = electrode)) +
                        geom_topo(grid_res = 200,
                                  colour = "white",
                                  size = 0.1,
                                  interp_limit = "head",
                                  chan_markers = "point",
                                  chan_size = 0.25,
                                  head_size = 0.5,
                                  method = "gam", breaks = 10) + 
                        scale_fill_viridis_c(option = "H")+
                        facet_wrap(~group, ncol = 1)+
                        theme_void() + 
                        coord_equal() + 
                        labs(subtitle = .y, fill = .y) +
                        theme(plot.subtitle = element_text(colour = "black",size = 8) ,
                              legend.position = "bottom",
                              legend.title = element_blank(),
                              legend.text = element_text(colour = "black",size = 6,angle = 40),
                              strip.text  = element_text(colour = "black",size = 8,angle = 0))) ) 


## Save -------
tp_s1 = cowplot::plot_grid(plotlist = topo_event_plots$plots,cols = 6)

ggsave("./Figures/figure_3_supplement_2.pdf",plot = tp_s1, width = 18, height = 8, units = "cm")

